unit fMAG;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ORCtrls, StdCtrls, ComCtrls, ORNet, ORFn, Menus, ExtCtrls;

type
  TfrmMAG = class(TForm)
    stgrCal: TCaptionStringGrid;
    btnCurr: TButton;
    HeaderControl1: THeaderControl;
    lbTemp: TORListBox;
    lblMonth: TLabel;
    btnPrev: TButton;
    btnNext: TButton;
    pmCal: TPopupMenu;
    Details1: TMenuItem;
    AddNote1: TMenuItem;
    timMAG: TTimer;
    procedure FillCalendar;
    procedure btnCurrClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure stgrCalMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Refresh(Month: string);
    procedure timMAGTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMAG: TfrmMAG;
  CalMonth: string;

procedure Calendar;

implementation

{$R *.dfm}

uses SCMMain;

procedure Calendar;
begin
  frmMAG := TfrmMAG.Create(Application);
  try
    with frmMAG do
    begin
      frmMAG.Caption := frmMag.Caption + SpecName;
      Refresh('C');
      ShowModal;
    end;
  finally
    frmMAG.Release;
  end;
end;

procedure TfrmMAG.FillCalendar;
var
  Cell: TRect;
  xcoord, ycoord, ACol, ARow: integer;
  Block, ID, glw, J, x, y: integer;
  Day, Data, Holiday, Info, IType, IName: string;
begin
  for Block := 0 to 34 do
    begin
      Data := lbTemp.Items[Block];
      Day  := piece(Data, '^', 1);
      ID   := StrToInt(piece(Data, '^', 2));
      if ID = 3 then Holiday := piece(Data, '^', 3);
      stgrCal.Canvas.Brush.Style := bsSolid;
      stgrCal.Canvas.Font.Color := clBlack;
      stgrCal.Canvas.Font.Size  := 16;
      if ID = 0 then    // day in previous or next month
        begin
          stgrCal.Canvas.Brush.Color := clCream;
          stgrCal.Canvas.Font.Color  := clMedGray;
        end;
      if ID = 1 then    // day in current month
        begin
          stgrCal.Canvas.Brush.Color := clWindow;
          stgrCal.Canvas.Font.Color  := clWindowText;
        end;
      //  day is current day
      if ID = 2 then stgrCal.Canvas.Brush.Color := clMoneyGreen;
      //  day is a holiday
      if ID = 3 then stgrCal.Canvas.Brush.Color := clSkyBlue;
      if (Block = 0) or (Block < 7) then
        begin
          ACol := Block;
          ARow := 0;
        end;
      if (Block > 6) and (Block < 14) then
        begin
          ACol := Block - 7;
          ARow := 1;
        end;
      if (Block > 13) and (Block < 21) then
        begin
          ACol := Block - 14;
          ARow := 2;
        end;
      if (Block > 20) and (Block < 28) then
        begin
          ACol := Block - 21;
          ARow := 3;
        end;
      if (Block > 27) and (Block < 35) then
        begin
          ACol := Block - 28;
          ARow := 4;
        end;
      Cell := stgrCal.CellRect(ACol, ARow);
      stgrCal.Canvas.FillRect(Cell);
      glw := stgrCal.GridLineWidth;
      xcoord := ACol * (stgrCal.DefaultColWidth + glw) + 2;
      ycoord := ARow * (stgrCal.DefaultRowHeight + glw);
      stgrCal.Canvas.TextOut(xcoord, ycoord, Day);
      if ID = 3 then
        begin
          if length(Day) = 1 then x := xcoord + 12;
          if length(Day) = 2 then x := xcoord + 32;
          stgrCal.Canvas.Font.Size := 4;
          stgrCal.Canvas.TextOut(x, ycoord, Holiday);
        end;
      ycoord := ycoord + 20;
      for J := 4 to 12 do
        begin
          Info  := piece(Data, '^', J);
          if Info = '' then Break;
          IType := piece(Info, ':', 1);
          IName  := piece(Info, ':', 2);
          stgrCal.Canvas.Font.Size := 8;
          if IType = 'R' then stgrCal.Canvas.Font.Color := clBlue;
          if IType = 'S' then stgrCal.Canvas.Font.Color := clGreen;
          if IType = 'N' then stgrCal.Canvas.Font.Color := clRed;
          y := ycoord + ((J-4) * 12);
          stgrCal.Canvas.TextOut(xcoord, y, IName);
        end;
    end;
  lblMonth.Caption := lbTemp.Items[35];
end;

procedure TfrmMAG.btnCurrClick(Sender: TObject);
begin
  Refresh('C');
end;

procedure TfrmMAG.btnPrevClick(Sender: TObject);
begin
  Refresh('P');
end;

procedure TfrmMAG.btnNextClick(Sender: TObject);
begin
  Refresh('N');
end;

procedure TfrmMAG.stgrCalMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  coord: TGridCoord;
  ACol, ARow, Block: integer;
  Data: string;
begin
  coord := stgrCal.MouseCoord(x, y);
  ACol  := coord.x;
  ARow  := coord.y;
  Block := ACol + (ARow * 7);
  Data  := lbTemp.Items[Block];
end;

procedure TfrmMAG.Refresh(Month: string);
begin
  CallV('APTWL GET CALENDAR', [SpecIFN, Month]);
  lbTemp.Items := RPCBrokerV.Results;
  FillCalendar;
end;

procedure TfrmMAG.timMAGTimer(Sender: TObject);
begin
  Refresh('C');
end;

end.
